' Simulated Radar Screen.
' Mostly just fooling around on this one.
' Some parts might be useful in other contexts.
' Rev 1.0.0 William M Leue 1/11/2021
' Rev 1.1.0 1/16/2021 
'   adds short delay after blit to minimize video glitches on some units
'   allows users to specify number of targets on start, increase during game
'   adds a few command hints to screen.
option default integer
option base 1

const SCREEN_X = 240
const SCREEN_Y = 300
const SCREEN_RADIUS = 200
const NUM_RINGS = 3
const SCREEN_SCALE = SCREEN_RADIUS/(NUM_RINGS+1)
const MAX_TARGETS = 12
const TARGET_PATH_INC = 0.07*SCREEN_RADIUS
const BLIP_RADIUS = 3
const PHOSPHOR_TIME_CONST = 200.0

const TABLE_X =  499
const TABLE_Y = 100
const TABLE_W = 300
const TABLE_H = 400
const TABLE_NCOLS = 3

const UP = 128

dim scolor = RGB(0, 20, 0)
dim float angle = 0.0

dim num_targets
dim desired_targets
dim target_coords(MAX_TARGETS, 4)
dim float target_angles(MAX_TARGETS)
dim target_lock(MAX_TARGETS)
dim target_count(MAX_TARGETS)
dim target_decay(MAX_TARGETS)
dim target_ids$(MAX_TARGETS)
dim range_flag(MAX_TARGETS)

dim table_col_widths(TABLE_NCOLS) = (70, 130, 100)
dim sortby = 3
dim descending(TABLE_NCOLS)

dim SCOLORS(3) = (RGB(0, 255, 0), RGB(0, 200, 0), RGB(0, 100, 0))

dim cmd = 0

' Main program
mode 1,16
open "debug.txt" for output as #1
cls
do
  input "How many radar targets (1-12) [more targets = slower sweep]: ", num_targets
  if num_targets = 0 then
    close #1
    end
  end if
  if num_targets >= 1 and num_targets <= MAX_TARGETS then
    exit do
  end if
loop
desired_targets = num_targets
for i = 1 to num_targets
  InitTarget i
next i
sortby = 1
f$ = INKEY$
do
  DrawScreen angle, scolor, num_targets
  angle = angle + 1.0
  if angle >= 360.0 then
    angle = 0.0
  end if
  f$ = INKEY$
  if f$ <> "" then
    cmd = asc(f$)
    if UCASE$(f$) = "T" then 
      if sortby = 1 then
        descending(1) = 1 - descending(1)
      end if
      sortby = 1
    end if
    if UCASE$(f$) = "R" then 
      if sortby = 2 then
        descending(2) = 1 - descending(2)
      end if
      sortby = 2
    end if
    if UCASE$(f$) = "B" then 
      if sortby = 3 then
        descending(3) = 1 - descending(3)
      end if
      sortby = 3
    end if
    if cmd = UP then
      if desired_targets < MAX_TARGETS then
        inc desired_targets
      end if
    end if
    if UCASE$(f$) = "Q" then
      exit do
    end if    
  end if
loop
close #1
end

' Draw the simulated radar screen with targets
sub DrawScreen angle as float, scolor, num
  local x, y, x2, y2, cx, cy, i, rs, rr, dc
  local float da
  page write 1
  ' draw the fixed screen features
  cls
  text MM.HRES\2, 20, "ATC Radar", "CT", 5
  text 505, 40, "V 1.1",, 7
  cx = SCREEN_X : cy = SCREEN_Y
  circle cx, cy, SCREEN_RADIUS,,,, scolor
  rs = SCREEN_RADIUS\(NUM_RINGS+1)
  rr = rs
  for i = 1 to NUM_RINGS
    circle cx, cy, rr,,, RGB(grey)
    rr = rr+rs
  next i
  text cx, cy-SCREEN_RADIUS-10, "N 0", "CB"
  text cx+SCREEN_RADIUS+10, cy, "E", "LM"
  text cx+SCREEN_RADIUS+10, cy+15, "90", "LM"
  text cx, cy+SCREEN_RADIUS+10, "S 180", "CT"
  text cx-SCREEN_RADIUS-10, cy, "W", "RM"
  text cx-SCREEN_RADIUS-10, cy+15, "270", "RM"
  ' draw the sweeping line
  x = cx + SCREEN_RADIUS*cos(rad(angle))    
  y = cy - SCREEN_RADIUS*sin(rad(angle))
  line cx, cy, x, y,, RGB(GREEN)
  ' refresh a target and let it move
  for i = 1 to num
    if angle = target_angles(i) then
      hit = 1
      AdvanceTarget i
      target_decay(i) = 0
    end if
    DrawTarget i
    DrawTargetTable num
    range_flag(i) = 0
  next i
  ' prevent retriggering when a target moves
  ' into a position that will be swept on this pass
  for i = 1 to num
    inc target_count(i)
    if target_count(i) >= 350 then
      target_lock(i) = 0
    end if      
  next i
  page write 0
  page copy 1 to 0, B
  pause 30
end sub

' Initialize target positions and trajectories
' Starting target positions are near edge of screen
' at a random angle.
sub InitTarget which
  local x, y, cx, cy, dx, dy, q, x2, y2, dx2, dy2
  local float radius, angle, cradius, cangle, tangle, speed, tpi, r2
  cx = SCREEN_X : cy = SCREEN_Y
  ' determine angle and coordinates of start position
  angle = rnd()*360.0
  target_angles(which) = int(angle)
  radius = SCREEN_RADIUS - rnd()*10.0
  x = cx + int(radius*cos(rad(angle)) + 0.5)
  y = cy - int(radius*sin(rad(angle)) + 0.5)
  target_coords(which, 1) = x
  target_coords(which, 2) = y
  ' determine how close to screen center the target path will come
  cradius = 0.85*rnd()*SCREEN_RADIUS
  cangle = deg(atan2(cradius, radius))
  if dy < 0 then
    cangle = -cangle
  else
    cangle = 360.0 - cangle
  end if
  tangle = angle + cangle - 180.0
  ' determine target speed
  tpi = TARGET_PATH_INC
  speed = tpi+ rnd()*tpi/2.0
  dx = int(speed*cos(rad(tangle)) + 0.5)
  dy = -int(speed*sin(rad(tangle)) + 0.5)
  ' try to fix issues with target path
  x2 = x+dy : y2 = y+dy
  dx2 = x2-x : dy2 = y2-y
  r2 = sqr(dx2*dx2 + dy2*dy2)
  if r2 > radius then
    tangle = tangle+180.0
    dx = int(speed*cos(rad(tangle)) + 0.5)
    dy = -int(speed*sin(rad(tangle)) + 0.5)
  end if
  ' save path increments for target updates
  target_coords(which, 3) = dx
  target_coords(which, 4) = dy
  ' init rest of target info
  target_ids$(which) = RID$()
  target_lock(which) = 0
  target_decay(which) = 0
end sub

' Draw the specified target if within range
sub DrawTarget which
  local x, y, cx, cy, dx, dy, dx2, dy2, c, g, vc
  local float r
  cx = SCREEN_X : cy = SCREEN_Y
  x = target_coords(which, 1)
  y = target_coords(which, 2)
  dx = target_coords(which, 3)
  dy = target_coords(which, 4)
  ' simulate phosphor glow exponential decay
  dx2 = x - cx : dy2 = y - cy
  r = sqr(dx*dx + dy*dy)
  if r <= SCREEN_RADIUS then
    g = int(255*ExpDecay(target_decay(which)))
    c = RGB(0, g, 0)
    vc = RGB(g, g\2, 0)
    inc target_decay(which)
    ' draw target blip, vector, and ID
    text x-2, y-2, target_ids$(which), "RB",,, c, SCOLOR
    line x, y, x+dx, y+dy,, vc
    circle x, y, BLIP_RADIUS,,, c, c
  end if
end sub

' Advance a target on a predefined trajectory
' If target has moved out of range, overwrite it
' with a new random target
sub AdvanceTarget which
  local dx, dy, tx, ty, x, y, cx, cy, q, r
  local float angle
  if target_lock(which) then
    exit sub
  end if
  cx = SCREEN_X : cy = SCREEN_Y
  x = target_coords(which, 1)
  y = target_coords(which, 2)
  dx = x - cx : dy = y - cy
  r = sqr(dx*dx + dy*dy)
  ' Replace a target that has gone out of range
  if r > SCREEN_RADIUS then
    InitTarget which
    exit sub
  end if
  ' Add a new target if it has been requested
  if desired_targets > num_targets then
    inc num_targets
    InitTarget num_targets
  end if
  ' do the position increment
  tx = target_coords(which, 3)
  ty = target_coords(which, 4)
  inc x, tx : inc y, ty
  target_coords(which, 1) = x
  target_coords(which, 2) = y
  ' recompute the angle from screen center to target
  dx = x - cx : dy = (y - cy)
  angle = deg(atan2(dy, dx))
  if dy < 0 then
    angle = -angle
  else
    angle = 360.0 - angle
  end if
  target_angles(which) = int(angle)
  if target_angles(which) = 360 then
    target_angles(which) = 0
  end if
  ' update the anti-retrigger variables
  target_count(which) = 0
  target_lock(which) = 1
end sub

' Simulate an exponential decay in brightness
function ExpDecay(n) as float
  local float a
  a = -n/PHOSPHOR_TIME_CONST
  ExpDecay = exp(a)
end function

' Generate a random Blip ID
function RID$()
  local c1, c2, d
  c1 = int(1+rnd()*26)
  c2 = int(1+rnd()*26)
  d = int(5+rnd()*94)
  RID$ = chr$(64+c1) + chr$(64+c2) + str$(d)
end function

' Draw the Target Table
sub DrawTargetTable num
  local i, x, y, dx, dy, cx, cy, ty, q, cw, c, kc1, kc2, kc3
  local float range, angle, bearing, srange
  local tid$(MAX_TARGETS)
  local float trange(MAX_TARGETS), tbearing(MAX_TARGETS)
  local index(MAX_TARGETS), key1, key2, key3
  local labels$(TABLE_NCOLS) = ("Target", "Range", "Bearing")

  ' Draw fixed parts of the table
  nt$ = "Num Targets: " + str$(num_targets) + "[" + str$(desired_targets) + "]"
  cat nt$, " UP arrow for more"
  text TABLE_X, TABLE_Y-35, nt$
  text TABLE_X+TABLEW\2, TABLE_Y-20, "Enter 'T', 'R', or 'B' to change sort"
  box TABLE_X, TABLE_Y, TABLE_W, TABLE_H
  cw = 0
  select case sortby
    case 1
      kc1 = RGB(CYAN) : kc2 = RGB(WHITE) : kc3 = RGB(WHITE)
    case 2
      kc1 = RGB(WHITE) : kc2 = RGB(CYAN) : kc3 = RGB(WHITE)
    case 3
      kc1 = RGB(WHITE) : kc2 = RGB(WHITE) : kc3 = RGB(CYAN)
  end select   
  line TABLE_X, TABLE_Y+20, TABLE_X+TABLE_W, TABLE_Y+20
    
  for i = 1 to TABLE_NCOLS
    l$ = labels$(i)
    if sortby = i then
      cat l$, chr$(146+descending(i))
    end if
    select case i
      case 1
        cw = 0        
        text TABLE_X+cw+10, TABLE_Y+5, l$,,,, kc1
      case 2
        cw = table_col_widths(1)
        line TABLE_X+cw, TABLE_Y, TABLE_X+cw, TABLE_Y+TABLE_H
        text TABLE_X+cw+10, TABLE_Y+5, l$,,,, kc2
      case 3
        cw = table_col_widths(1) + table_col_widths(2)
        line TABLE_X+cw, TABLE_Y, TABLE_X+cw, TABLE_Y+TABLE_H
        text TABLE_X+cw+10, TABLE_Y+5, l$,,,, kc3
    end select
  x = TABLE_X+10 : y = TABLE_Y + TABLE_H + 10
  text x, y, "Press 'Q' to Quit"
  next i
  
  ' Draw the content
  cx = SCREEN_X : cy = SCREEN_Y
  for i = 1 to num
    tid$(i) = target_ids$(i)
    x = target_coords(i, 1) : y = target_coords(i, 2)
    dx = x - cx : dy = y - cy
    range = sqr(dx*dx + dy*dy)
    srange = range/SCREEN_SCALE
    trange(i) = srange
    angle = deg(atan2(dy, dx))
    q = Quadrant(dx, dy)
    select case q
      case 1, 2
        angle = -angle
      case 3, 4
        angle = 360.0 - angle
    end select
    if angle = 360.0 then angle = 0.0
    select case q
      case 1
        bearing = 90.0 - angle
      case 2,3,4
        bearing = 450.0 - angle
    end select
    tbearing(i) = bearing
  next i
  select case sortby
    case 1
      sort tid$(), index(), descending(1),, num_targets
    case 2
      sort trange(), index(), descending(2),, num_targets
    case 3
      sort tbearing(), index(), descending(3),, num_targets
  end select
  c = RGB(GREEN)
  for i = 1 to num
    select case sortby
      case 1
        key1 = i : key2 = index(i) : key3 = index(i)
      case 2
        key1 = index(i) : key2 = i : key3 = index(i)
      case 3
        key1 = index(i) : key2 = index(i) : key3 = i
    end select
    ty = TABLE_Y + 25 + 20*(i-1)
    cw = 0
    text TABLE_X+10, ty, tid$(key1),,,, c
    inc cw, table_col_widths(1)
    if trange(key2) <= 4.0 then
      text TABLE_X+cw+10, ty, format$(trange(key2), "%.2f"),,,, c
    else
      text TABLE_X+cw+10, ty, "Out of Range",,,, RGB(RED)
    end if
    inc cw, table_col_widths(2)
    text TABLE_X+cw+10, ty, format$(tbearing(key3), "%.2f"),,,, c
  next i
end sub

function Quadrant(dx, dy)
  local q = 0
  if dx >= 0 and dy < 0 then q = 1
  if dx < 0 and dy < 0 then q = 2
  if dx < 0 and dy >= 0 then q = 3
  if dx >= 0 and dy >= 0 then q = 4
  Quadrant = q
end function
